from __future__ import generators
import plus
import Arenas
import random
import math

class ClawTop(Arenas.SuperArena):
    "Battle it out on a platform in the middle of the ocean! But watch out for the four spinners, and avoid the edge of the platform. If your bot falls in the water it will short circuit and be eliminated!"
    name = "Ocean Platform"
    preview = "oceanarena/oceanarena_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-36, 36, 36, -36)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/oceanarena/oceanarena.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0.7,0.8,1)
        degrad = 0.01745
        #############

        self.AddStaticCamera("              Overhead", (0, 45, 0), (1.5708, 3.1514), 1.1)

        self.AddStaticCamera("              Side-1", (-30, 42, 30), (.7, 2.35), 1)

        self.AddWatchCamera("               Watch-1", (0, 40, 0), (24, 32, 60*degrad, 45*degrad))
        self.AddWatchCamera("               Watch-2", (35, 35, 35), (24, 28, 45*degrad, 30*degrad))
        self.AddWatchCamera("               Watch-3", (-35, 35, -35), (64, 96, 22*degrad, 20*degrad))


        #############
        self.AddCollisionLine((-28, 28), (-28, -28))
        self.AddCollisionLine((-28, -28), (28, -28))
        self.AddCollisionLine((28, -28), (28, 28))
        self.AddCollisionLine((28, 28), (-28, 28))
        self.players = ()
        
    def AddShadowReceivers(self):
        #Shadow Light Sources
        self.SetShadowSource(0.653, 6.894, -0.418)
        
        #Arena Shadow Faces
        self.AddShadowTriangle((-6.7561,0.0170998,17.1496), (-6.7561,0.0170998,-5.58268), (6.27657,0.0170998,17.1496))
        self.AddShadowTriangle((6.27657,0.0170998,-5.58268), (6.27657,0.0170998,17.1496), (-6.7561,0.0170998,-5.58268))
        self.AddShadowTriangle((6.27657,0.0170998,-5.58268), (-6.7561,0.0170998,-5.58268), (6.27657,6.94643,-5.58268))
        self.AddShadowTriangle((-6.7561,6.94643,-5.58268), (6.27657,6.94643,-5.58268), (-6.7561,0.0170998,-5.58268))
        self.AddShadowTriangle((-6.7561,0.0170998,17.1496), (6.27657,0.0170998,17.1496), (-6.7561,6.94643,17.1496))
        self.AddShadowTriangle((6.27657,6.94643,17.1496), (-6.7561,6.94643,17.1496), (6.27657,0.0170998,17.1496))
        self.AddShadowTriangle((-6.7561,0.0170998,-5.58268), (-6.7561,0.0170998,17.1496), (-6.7561,6.94643,-5.58268))
        self.AddShadowTriangle((-6.7561,6.94643,17.1496), (-6.7561,6.94643,-5.58268), (-6.7561,0.0170998,17.1496))
        
        
    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)
        
    def HazardsOn(self, on):
        if on:
            self.ambience = plus.createSound("Sounds/heavy_motor_loop.wav", False, (0, 0, 0))
            plus.loopSound(self.ambience)
            
            self.espinner = self.GetHinge("Hinge01")
            self.espinner.SetAutoLocks(False, True)
            self.espinner.SetPowerSettings(50, 100)
            self.espinner.Lock(False)
            self.espinner.SetDirection(-100)
            
            self.wspinner = self.GetHinge("Hinge02")
            self.wspinner.SetAutoLocks(False, True)
            self.wspinner.SetPowerSettings(50, 100)
            self.wspinner.Lock(False)
            self.wspinner.SetDirection(100)
            
            self.nspinner = self.GetHinge("Hinge03")
            self.nspinner.SetAutoLocks(False, True)
            self.nspinner.SetPowerSettings(50, 100)
            self.nspinner.Lock(False)
            self.nspinner.SetDirection(100)
            
            self.sspinner = self.GetHinge("Hinge04")
            self.sspinner.SetAutoLocks(False, True)
            self.sspinner.SetPowerSettings(50, 100)
            self.sspinner.Lock(False)
            self.sspinner.SetDirection(-100)
            
            self.SetSubMaterialSound("espinner", "metal", 1.0, "Sounds\\hzd_comp_hit.wav")
            self.SetSubMaterialSound("wspinner", "metal", 1.0, "Sounds\\hzd_comp_hit.wav")
            self.SetSubMaterialSound("nspinner", "metal", 1.0, "Sounds\\hzd_comp_hit.wav")
            self.SetSubMaterialSound("sspinner", "metal", 1.0, "Sounds\\hzd_comp_hit.wav")
            
        return Arenas.SuperArena.HazardsOn(self, on)
        
    def Tick(self):
        for each in self.players:
            if plus.getLocation(each)[1] < -4:
                plus.eliminatePlayer(each)

        if plus.getLocation(0)[1] < -4:
            plus.force(0, 0, 170 * plus.getWeight(0), 0)
        if plus.getLocation(1)[1] < -4:
            plus.force(1, 0, 170 * plus.getWeight(1), 0)
        if plus.getLocation(2)[1] < -4:
            plus.force(2, 0, 170 * plus.getWeight(2), 0)
        if plus.getLocation(3)[1] < -4:
            plus.force(3, 0, 170 * plus.getWeight(3), 0)

        return Arenas.SuperArena.Tick(self)
        
    def __del__(self):
        if self.bHazardsOn:
            plus.removeSound(self.ambience)
        Arenas.SuperArena.__del__(self)
        
Arenas.register(ClawTop)
